package gov.va.med.mhv.phr.appointments.portlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.commons.lang.StringUtils;
import org.displaytag.properties.SortOrderEnum;
import org.tigris.atlas.service.EntityCollectionServiceResponse;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.appointments.decorator.AppointmentDecorator;
import gov.va.med.mhv.phr.appointments.decorator.AppointmentTableDecorator;
import gov.va.med.mhv.phr.appointments.model.AppointmentsRowSorter;
import gov.va.med.mhv.phr.appointments.portlet.AppointmentsPageFlowController;
import gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController;
import gov.va.med.mhv.phr.service.AppointmentCollectionServiceResponse;
import gov.va.med.mhv.phr.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.phr.transfer.Appointment;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.delegate.ActivityAuditServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.Activity;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;

/*
 * This class is the Page Flow Controller for the View Appointments extract
 * 
 * @author - Jeff Robinson (Aquilent, Inc.)
 */
@Jpf.Controller(strutsMerge = "/WEB-INF/struts-override.xml")
public class AppointmentsPageFlowController extends ExtractPageFlowBaseController
{
    private static final long serialVersionUID = 2066922212L;

    private static final String ENTITY_NAME = StringUtils.substringAfterLast(
        Appointment.class.getName(), "."); 
    
    private static final String HELP_PREFIX = "PHR_Appointments_";

    private static final String TABLE_UID = "Appointments";
    
    private static final String TABLE_SESSION_KEY = 
        "gov.va.med.mhv.phr.appointments";
	private static final String ROW_LIST_SESSION_KEY = "rowListPage";
	private List<List> rowListPage = new ArrayList<List>();
	
    private static final ExtractType EXTRACT_TYPE = ExtractType.getEnum(
        ExtractType.APPOINTMENTS);

    private AppointmentDecorator currentAppointment = null;

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "appointmentSummary.jsp"),
        @Jpf.Forward(name = "patient-not-ipa-ed", 
            path="notInPersonAuthenticated.jsp"),
        @Jpf.Forward(name = "patient-not-correlated", 
            path="../../common/notPatientCorrelated.jsp"),
        @Jpf.Forward(name = "failure", path = "appointmentSummary.jsp")
    })
    @Override
    public Forward begin() {
        return super.begin();
    }

    /*
     * Method execute when refresh button is pressed
     *   (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#refresh()
     */
    @Jpf.Action(
        forwards = { @Jpf.Forward(name = "success", action = "begin") }
    )
    public Forward refresh() {
        Forward forward = new Forward("success");
        return forward;
    }

    /*
     * Callback that is invoked when this controller instance is created.
     */
    @Override
    protected void onCreate() {
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getTableUID()
     */
    @Override
    public String getTableUID() {
        return TABLE_UID;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getDefaultSortProperty()
     */
    @Override
    public Integer getDefaultSortProperty() {
        return 1;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getDefaultSortOrder()
     */
    @Override
    public SortOrderEnum getDefaultSortOrder() {
        return SortOrderEnum.DESCENDING;
    }

    /*
     * This method returns the name of the custom row sorting class for
     * appointments.
     * 
     * @return a String containing the name of the custom sorter class
     */
    public String getSortClassName() {
        return AppointmentsRowSorter.class.getName();
    }

    /*
     * This method returns the name of the Appointment decorator class
     * 
     * @return a String contaning the name of the Appointment decorator class
     */
    public String getDecoratorClassName() {
        return AppointmentTableDecorator.class.getName();
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityListMaintenancePageFlowController#
     * getTableSessionKey()
     */
    @Override
    protected String getTableSessionKey() {
        return TABLE_SESSION_KEY;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
     * getTransferObjectClass()
     */
    @Override
    protected Class getTransferObjectClass() {
        return Appointment.class;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
     * getEntityName()
     */
    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.AbstractPageFlowController#getFormClass()
     */
    @Override
    protected Class getFormClass() {
        return AppointmentsPageFlowController.class;
    }

    /*
     * This method returns the current the current appointment.
     * 
     * @return the AppointmentDecorator for the current appointment
     */
    public AppointmentDecorator getCurrentAppointment() {
        return currentAppointment;
    }

    /*
     * This method returns a collection of the appointments
     * 
     * @return a Collection contaning a number of Appointment objects
     */
    public Collection getAppointments() {
        Collection entities = getEntities();
        return (entities != null) ? entities : new ArrayList();
    }
    
    /*
     * This method 
     */
    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "appointmentSummaryPF.jsp")}
    )
    
    /*
     * 
     */
    public Forward viewPrinterFriendlyIndex() {
    	getRequest().setAttribute("_appointments", getRowListPage());
        return new Forward("success");
    }
    
	@SuppressWarnings("unchecked")
    protected List getRowListPage() {
		Object rowList = getSession().getAttribute(ROW_LIST_SESSION_KEY);
		if (rowList != null) {
			rowListPage.clear();
			rowListPage.addAll((List) rowList);
			getSession().removeAttribute(ROW_LIST_SESSION_KEY);
		}
		return Collections.unmodifiableList(rowListPage);
	}

    /*
     * 
     */
    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "appointmentDetailPF.jsp")}
    )
    public Forward viewPrinterFriendlyDetails() {
        return determineForward();
    }

    /*
     *  (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityListMaintenancePageFlowController#returnToListAction()
     */
    @Jpf.Action(forwards = { 
        @Jpf.Forward(name = "success", path = "appointmentSummary.jsp") 
    })
    @Override
    public Forward returnToListAction() {
        currentAppointment = null;
        return super.returnToListAction();
    }

    /*
     * 
     */
    @Jpf.Action(forwards = { 
        @Jpf.Forward(name = "viewSummary", path = "returnToListAction.do"),
        @Jpf.Forward(name = "viewDetails", path = "appointmentDetail.jsp") 
    })
    public Forward returnToViewAction() {
        return (currentAppointment != null) ? new Forward("viewDetails")
            : new Forward("viewSummary");
    }

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "appointmentDetail.jsp"),
        @Jpf.Forward(name = "failure", path = "appointmentSummary.jsp") 
    })
    /**
     * Loads the appropriate appointment details and forwards to the
     * associated details view page.
     * @return Forward denoting the details view 
     */
    public Forward viewDetails() {
        Forward forward = null;
        Appointment appointment = findAppointmentById(getDetailsId());
        if (appointment != null) {
            currentAppointment = new AppointmentDecorator(appointment);
            forward = determineForward();
        } else {
            forward = determineForwardOnUnknownEntity("view");
        }
        return forward;
    }

    private Long getDetailsId() {
        final String requestID = getRequest().getParameter("id");
        Precondition.assertNotBlank("request.id", requestID);
        Long id = null;
        try {
            id = Long.parseLong(requestID);
        } catch (NumberFormatException e) {
            Precondition.fail("request.id", "a Long", requestID,
                "Unable to determine id for selected appointment.");
        }
        return id;
    }

    private Appointment findAppointmentById(Long id) {
        Collection appointments = getAppointments(); 
        if (appointments != null) {
            for(Object a: appointments) {
                Appointment appointment = (Appointment) a;
                if (id.equals(appointment.getId())) { 
                    return appointment;
                }
            }
        }
        return null;
    }

    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "appointmentSummary.jsp")}
    )
    
    /*
     * 
     */
    public Forward handlePagingAndSorting() {
        return super.handlePagingAndSorting();
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.portlet.
     * PharmacyMedicationListPageFlowController#getSummaryHelpURI()
     */
    public String getSummaryHelpURI() {
        return createHelpURI(HELP_PREFIX + "SummaryHelp.html");
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.portlet.
     * PharmacyMedicationListPageFlowController#getSummaryHelpURI()
     */
    public String getDetailsHelpURI() {
        return createHelpURI(HELP_PREFIX + "DetailsHelp.html");
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractType()
     */
    @Override
    protected ExtractType getExtractType() {
        return EXTRACT_TYPE;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractName()
     */
    @Override
    public String getExtractName() {
        // We cannot use the extract type name, because the enumeration name
        // cannot contain special characters like /
        return "VA Appointments";
    }

    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * loadExtract()
     */
    @Override
    protected EntityCollectionServiceResponse loadExtract() {
        return ServiceDelegateFactory.createAppointmentsBusinessServiceDelegate().findAppointments(getPatient());
    }

    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * createExtractServiceResponse()
     */
    @Override
    protected EntityCollectionServiceResponse createExtractServiceResponse() {
        return new AppointmentCollectionServiceResponse();
    }

    /*
     *  (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#showNotInPersonAuthenticated()
     */
    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", 
            path="../../common/notInPersonAuthenticated.jsp")
    })
    @Override
    public Forward showNotInPersonAuthenticated() {
        return super.showNotInPersonAuthenticated();
    }

	@Override
	protected void auditView() {
		ActivityAuditServiceDelegate auditDelegate =  
		gov.va.med.mhv.usermgmt.service.delegate.
         ServiceDelegateFactory.createActivityAuditServiceDelegate();
		
		Activity activity = 
			TransferObjectFactory.createActivity();
	
		activity.setAction(ActivityActionTypeEnumeration
							.getEnum(ActivityActionTypeEnumeration.VIEW));
		activity.setActionType(ActivityTypeEnumeration.APPOINTMENTS);
		activity.setPerformerType(ActivityActorTypeEnumeration
							.getEnum(ActivityActorTypeEnumeration.SELF));
		activity.setSubjectId(getCurrentUserId());
		activity.setCompletionTime(new java.sql.Timestamp(
							java.util.Calendar.getInstance().getTimeInMillis()));
		activity.setStatus(Boolean.TRUE);
		
		auditDelegate.audit(activity);
	}
 
}
